% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/range.R
\name{step_range}
\alias{step_range}
\title{Scaling Numeric Data to a Specific Range}
\usage{
step_range(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  min = 0,
  max = 1,
  ranges = NULL,
  skip = FALSE,
  id = rand_id("range")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{min}{A single numeric value for the smallest value in the
range.}

\item{max}{A single numeric value for the largest value in the
range.}

\item{ranges}{A character vector of variables that will be
normalized. Note that this is ignored until the values are
determined by \code{\link[=prep]{prep()}}. Setting this value will
be ineffective.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_range} creates a \emph{specification} of a recipe
step that will normalize numeric data to be within a pre-defined
range of values.
}
\details{
When a new data point is outside of the ranges seen in
the training set, the new values are truncated at \code{min} or
\code{max}.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble with columns
\code{terms} (the selectors or variables selected), \code{min}, and \code{max} is
returned.
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(biomass, package = "modeldata")

biomass_tr <- biomass[biomass$dataset == "Training", ]
biomass_te <- biomass[biomass$dataset == "Testing", ]

rec <- recipe(
  HHV ~ carbon + hydrogen + oxygen + nitrogen + sulfur,
  data = biomass_tr
)

ranged_trans <- rec \%>\%
  step_range(carbon, hydrogen)

ranged_obj <- prep(ranged_trans, training = biomass_tr)

transformed_te <- bake(ranged_obj, biomass_te)

biomass_te[1:10, names(transformed_te)]
transformed_te

tidy(ranged_trans, number = 1)
tidy(ranged_obj, number = 1)
\dontshow{\}) # examplesIf}
}
\seealso{
Other normalization steps: 
\code{\link{step_center}()},
\code{\link{step_normalize}()},
\code{\link{step_scale}()}
}
\concept{normalization steps}
