% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lincomb.R
\name{step_lincomb}
\alias{step_lincomb}
\title{Linear combination filter}
\usage{
step_lincomb(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  max_steps = 5,
  removals = NULL,
  skip = FALSE,
  id = rand_id("lincomb")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose variables for this step.
See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Not used by this step since no new variables are created.}

\item{trained}{A logical to indicate if the quantities for preprocessing have
been estimated.}

\item{max_steps}{The number of times to apply the algorithm.}

\item{removals}{A character string that contains the names of columns that
should be removed. These values are not determined until \code{\link[=prep]{prep()}} is
called.}

\item{skip}{A logical. Should the step be skipped when the recipe is baked by
\code{\link[=bake]{bake()}}? While all operations are baked when \code{\link[=prep]{prep()}} is run, some
operations may not be able to be conducted on new data (e.g. processing the
outcome variable(s)). Care should be taken when using \code{skip = TRUE} as it
may affect the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_lincomb()} creates a \emph{specification} of a recipe step that will
potentially remove numeric variables that have exact linear combinations
between them.
}
\details{
This step can potentially remove columns from the data set. This may
cause issues for subsequent steps in your recipe if the missing columns are
specifically referenced by name. To avoid this, see the advice in the
\emph{Tips for saving recipes and filtering columns} section of \link{selections}.

This step finds exact linear combinations between two or more variables and
recommends which column(s) should be removed to resolve the issue. This
algorithm may need to be applied multiple times (as defined by \code{max_steps}).
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble is returned with
columns \code{terms} and \code{id}:

\describe{
\item{terms}{character, the selectors or variables selected}
\item{id}{character, id of this step}
}
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(biomass, package = "modeldata")

biomass$new_1 <- with(
  biomass,
  .1 * carbon - .2 * hydrogen + .6 * sulfur
)
biomass$new_2 <- with(
  biomass,
  .5 * carbon - .2 * oxygen + .6 * nitrogen
)

biomass_tr <- biomass[biomass$dataset == "Training", ]
biomass_te <- biomass[biomass$dataset == "Testing", ]

rec <- recipe(HHV ~ carbon + hydrogen + oxygen + nitrogen +
  sulfur + new_1 + new_2,
data = biomass_tr
)

lincomb_filter <- rec \%>\%
  step_lincomb(all_numeric_predictors())

lincomb_filter_trained <- prep(lincomb_filter, training = biomass_tr)
lincomb_filter_trained

tidy(lincomb_filter, number = 1)
tidy(lincomb_filter_trained, number = 1)
\dontshow{\}) # examplesIf}
}
\seealso{
Other variable filter steps: 
\code{\link{step_corr}()},
\code{\link{step_filter_missing}()},
\code{\link{step_nzv}()},
\code{\link{step_rm}()},
\code{\link{step_select}()},
\code{\link{step_zv}()}
}
\author{
Max Kuhn, Kirk Mettler, and Jed Wing
}
\concept{variable filter steps}
