% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_pairs.R
\name{compare_pairs}
\alias{compare_pairs}
\title{Compare all pairs of records}
\usage{
compare_pairs(
  pairs,
  by,
  comparators = list(default_comparator),
  x,
  y,
  default_comparator = identical(),
  overwrite = FALSE
)
}
\arguments{
\item{pairs}{a \code{pairs} object, such as generated by 
\code{\link{pair_blocking}}}

\item{by}{variables from \code{x} and \code{y} on which to compare the 
records.}

\item{comparators}{a names list of \link[=identical]{comparator functions}, 
for the named variables the given functions will be used to compare the 
records. For the remaining variables the \code{default_comparator} will 
be used.}

\item{x}{the first \code{data.frame}, when missing \code{attr(pairs, "x")} 
is used.}

\item{y}{the second \code{data.frame}, when missing \code{attr(pairs, "y")} 
is used.}

\item{default_comparator}{the default \link[=identical]{comparison function}.}

\item{overwrite}{overwrite exiting variables in \code{pairs}}
}
\value{
Returns the \code{pairs} object with a column added for each variable in 
\code{by}. The value is the column is given by the return value of the 
corresponding \link[=identical]{comparison function}.
}
\description{
Compare all pairs of records
}
\examples{
data("linkexample1", "linkexample2")
pairs <- pair_blocking(linkexample1, linkexample2, "postcode")
pairs <- compare_pairs(pairs, c("lastname", "firstname", "address", "sex"))

\dontshow{gc()}

}
