% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CIC_reconstruct.R
\name{CIC_reconstruct}
\alias{CIC_reconstruct}
\title{Reconstruct cumulative incidence curves}
\usage{
CIC_reconstruct(overallIPD, clicks1, arm, clicks2 = NULL)
}
\arguments{
\item{overallIPD}{The individual patient data from the overall (composite outcome) plot
that has already been processed through reconstructKM. Should have three columns: time,
status, and arm.}

\item{clicks1}{A data.frame with "time" and "cuminc" columns that are output from the
digitizing software, similar to what you would input for reconstructKM except it's a
cumulative incidence function for a specific event, not a survival function (make sure first click is (0,0)).}

\item{arm}{The arm corresponding to clicks1 and possibly clicks2.}

\item{clicks2}{Same as clicks1 but for the second event if it's provided. Default is null.}
}
\value{
An augmented version of overallIPD that additionally gives the cause
of the event (cause 1 or cause 2) as a fourth "event" column.
}
\description{
In competing risks situations, papers may provide one overall KM plot for
the composite outcome of event 1 or event 2 as well as cumulative incidence
plots for the each event separately. We can use these three plots to reconstruct
individual level data with event-specific labels (censored, event 1, or event 2).
Can also handle the case when the CIC for event 2 is not given.
Run this separately for each arm.
}
\examples{
data(pembro_clicks)
data(pembro_NAR)
augTabs <- format_raw_tabs(raw_NAR=pembro_NAR, raw_surv=pembro_clicks)
reconstruct <- KM_reconstruct(aug_NAR=augTabs$aug_NAR, aug_surv=augTabs$aug_surv)
IPD <- data.frame(arm=1, time=reconstruct$IPD_time, status=reconstruct$IPD_event)
clicks1 <- dplyr::mutate(pembro_clicks, cuminc=1-survival)
CIC_reconstruct(overallIPD = IPD, clicks1 = clicks1, arm=1, clicks2=NULL)
}
