% Generated by roxygen2 (4.0.2): do not edit by hand
\name{convert}
\alias{convert}
\alias{convert_test}
\alias{convert_train}
\title{Read data file and convert to binary format}
\arguments{
\item{r}{Object returned by \code{\link{Reco}}()}

\item{rawfile}{Path of data file, see section 'Data format' for details}

\item{outdir}{Directory in which the output binary file will be
generated. If missing, \code{tempdir()} will be used.}

\item{verbose}{Whether to show detailed information. Default is \code{TRUE}.}
}
\description{
These methods are member functions of class "\code{RecoSys}"
that convert training and testing data files into binary format.
The conversion is a preprocessing step prior to the model training part,
since data with this binary format could be accessed more efficiently.

The common usage of these methods is
\preformatted{r = Reco()
r$convert_train(rawfile, outdir, verbose = TRUE)
r$convert_test(rawfile, outdir, verbose = TRUE)}
}
\section{Data format}{

The data file required by these methods takes the format of sparse matrix
in triplet form, i.e., each line in the file contains three numbers
\preformatted{row col value}
representing a number in the rating matrix
with its location. In real applications, it typically looks like
\preformatted{user_id item_id rating}

\bold{NOTE}: \code{row} and \code{col} start from 0. So if the first user
rates 3 on the first item, the line will be
\preformatted{0 0 3}

\bold{NOTE}: For testing data, the file also needs to contain three
numbers each line. If the rating values are unknown, you can put any
number as placeholders.
\cr
Example data files are contained in the \code{recosystem/dat} directory.
}
\examples{
trainset = system.file("dat", "smalltrain.txt", package = "recosystem")
testset = system.file("dat", "smalltest.txt", package = "recosystem")
r = Reco()
r$convert_train(trainset)
r$convert_test(testset)
print(r)
}
\author{
Yixuan Qiu <\url{http://statr.me}>
}
\references{
LIBMF: A Matrix-factorization Library for Recommender Systems.
\url{http://www.csie.ntu.edu.tw/~cjlin/libmf/}

Y. Zhuang, W.-S. Chin, Y.-C. Juan, and C.-J. Lin.
A Fast Parallel Stochastic Gradient Method for Matrix Factorization in Shared Memory Systems.
Technical report 2014.
}
\seealso{
\code{\link{train}}, \code{\link{predict}}
}

