% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RecoSys.R
\name{train}
\alias{train}
\title{Training a Recommender Model}
\arguments{
\item{r}{Object returned by \code{\link{Reco}}().}

\item{train_path}{Path to the traning data file. See section \strong{Data Format}
for the details about the data format.}

\item{out_model}{Path to the model file that will be created.}

\item{opts}{A number of parameters and options for the model training.
            See section \strong{Parameters and Options} for details.}
}
\description{
This method is a member function of class "\code{RecoSys}"
that trains a recommender model. It will read a training data file and
create a model file at the specified locations. The model file contains
necessary information for prediction.

The common usage of this method is
\preformatted{r = Reco()
r$train(train_path, out_model = file.path(tempdir(), "model.txt"),
        opts = list())}
}
\section{Parameters and Options}{

The \code{opts} argument is a list that can supply any of the following parameters:

\describe{
\item{\code{dim}}{Integer, the number of latent factors. Default is 10.}
\item{\code{cost}}{Numeric, the regularization cost for latent factors. Default is 0.1.}
\item{\code{lrate}}{Numeric, the learning rate, which can be thought
                    of as the step size in gradient descent. Default is 0.1.}
\item{\code{niter}}{Integer, the number of iterations. Default is 20.}
\item{\code{nthread}}{Integer, the number of threads for parallel
                      computing. Default is 1.}
\item{\code{nmf}}{Logical, whether to perform non-negative matrix factorization.
                  Default is \code{FALSE}.}
\item{\code{verbose}}{Logical, whether to show detailed information. Default is
                      \code{TRUE}.}
}
}

\section{Data Format}{

The training data file takes the format of sparse matrix
in triplet form, i.e., each line in the file contains three numbers
\preformatted{row col value}
representing a number in the rating matrix
with its location. In real applications, it typically looks like
\preformatted{user_id item_id rating}

\bold{NOTE}: \code{row} and \code{col} start from 0. So if the first user
rates 3 on the first item, the line will be
\preformatted{0 0 3}

Example data files are contained in the \code{recosystem/dat} directory.
}
\examples{
trainset = system.file("dat", "smalltrain.txt", package = "recosystem")
r = Reco()
set.seed(123) # This is a randomized algorithm
r$train(trainset, opts = list(dim = 20, cost = 0.01, nthread = 2))
}
\author{
Yixuan Qiu <\url{http://statr.me}>
}
\references{
W.-S. Chin, Y. Zhuang, Y.-C. Juan, and C.-J. Lin.
A Fast Parallel Stochastic Gradient Method for Matrix Factorization in Shared Memory Systems.
ACM TIST, 2015.

W.-S. Chin, Y. Zhuang, Y.-C. Juan, and C.-J. Lin.
A learning-rate schedule for stochastic gradient methods to matrix factorization.
PAKDD, 2015.
}
\seealso{
\code{$\link{tune}()}, \code{$\link{output}()}, \code{$\link{predict}()}
}

