% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/red.R
\name{aoo}
\alias{aoo}
\title{Area of Occupancy (AOO).}
\usage{
aoo(layer, longlat = NULL)
}
\arguments{
\item{layer}{RasterLayer object representing the presence/absence map.}

\item{longlat}{Matrix of longitude and latitude (two columns) of each occurrence record.}
}
\value{
A single value in km2.
}
\description{
Calculates the Area of Occupancy of a species based on either records or predicted distribution.
}
\details{
AOO is calculated as the area of all known or predicted cells (usually 2x2 km) for the species.
}
\examples{
data(data.records)
data(data.sp)
aoo(data.sp, data.records)
aoo(data.sp)
}

