% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genericApiCall.R
\name{genericApiCall}
\alias{genericApiCall}
\alias{genericApiCall.redcapDbConnection}
\alias{genericApiCall.redcapApiConnection}
\title{Generic Interface the REDCap API.}
\usage{
genericApiCall(
  rcon,
  content,
  make_data_frame = TRUE,
  colClasses = NA,
  returnFormat = "csv",
  ...
)

\method{genericApiCall}{redcapDbConnection}(
  rcon,
  content,
  make_data_frame = TRUE,
  colClasses = NA,
  returnFormat = "csv",
  ...
)

\method{genericApiCall}{redcapApiConnection}(
  rcon,
  content,
  make_data_frame = TRUE,
  colClasses = NA,
  returnFormat = "csv",
  ...,
  error_handling = getOption("redcap_error_handling")
)
}
\arguments{
\item{rcon}{A REDCap connection object as generated by 
\code{redcapConnection}.}

\item{content}{\code{character(1)} The content argument for the
API call.}

\item{make_data_frame}{\code{logical(1)}. When \code{TRUE}, an
attempt is made to coerce the output to a data frame with
\code{read.csv}.  Otherwise, it is returned as a character
vector.}

\item{colClasses}{A named list of column names and
classes to apply via \code{read.csv}}

\item{returnFormat}{\code{character(1)} The format for the return.
Defaults to \code{"csv"}.}

\item{...}{Additional named arguments giving arguments to the
API method.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}
}
\description{
Permits users to make generic calls to the REDCap
  API. This allows use of API methods that do not yet have
  dedicated support.
}
