% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purgeRestoreProject.R
\name{purgeRestoreProject}
\alias{purgeRestoreProject}
\alias{preserveProject}
\alias{preserveProject.redcapApiConnection}
\alias{purgeProject}
\alias{purgeProject.redcapApiConnection}
\alias{restoreProject}
\alias{restoreProject.redcapApiConnection}
\alias{restoreProject.list}
\title{Purge and Restore Project Data}
\usage{
preserveProject(object, ...)

\method{preserveProject}{redcapApiConnection}(
  object,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list()
)

purgeProject(object, ...)

\method{purgeProject}{redcapApiConnection}(
  object,
  arms = FALSE,
  events = FALSE,
  users = FALSE,
  user_roles = FALSE,
  dags = FALSE,
  records = FALSE,
  purge_all = FALSE,
  flush = TRUE,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list()
)

restoreProject(object, ...)

\method{restoreProject}{redcapApiConnection}(
  object,
  project_information = NULL,
  arms = NULL,
  events = NULL,
  meta_data = NULL,
  mappings = NULL,
  repeating_instruments = NULL,
  users = NULL,
  user_roles = NULL,
  user_role_assignments = NULL,
  dags = NULL,
  dag_assignments = NULL,
  records = NULL,
  flush = TRUE,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list()
)

\method{restoreProject}{list}(
  object,
  rcon,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list()
)
}
\arguments{
\item{object, rcon}{A \code{redcapConnection} object. Except in
\code{restoreProject.list}, where \code{object} is a list of data frames
to use in restoring the project.}

\item{...}{Arguments to pass to other methods}

\item{error_handling}{\code{character(1)}. One of \code{c("error", "null")}.
An option for how to handle errors returned by the API.
see \code{\link[=redcapError]{redcapError()}}.}

\item{config}{A named \code{list}. Additional configuration parameters to pass to
\code{\link[httr:POST]{httr::POST()}}. These are appended to any parameters in
\code{rcon$config}.}

\item{arms}{Either \code{logical(1)} indicating if arms data should be
purged from the project; or a \code{data.frame} for restoring arms
data via \code{importArms}.}

\item{events}{Either \code{logical(1)} indicating if events data should be
purged from the project; or a \code{data.frame} for restoring events
data via \code{importEvents}}

\item{users}{Either \code{logical(1)} indicating if users data should be
purged from the project; or a \code{data.frame} for restoring users
data via \code{importUsers}. NOT YET IMPLEMENTED}

\item{user_roles}{Either \code{logical(1)} indicating if user roles data should be
purged from the project; or a \code{data.frame} for restoring user roles
data via \code{importUserRoles}. NOT YET IMPLEMENTED}

\item{dags}{Either \code{logical(1)} indicating if DAG data should be
purged from the project; or a \code{data.frame} for restoring DAGs
data via \code{importDags}. NOT YET IMPLEMENTED}

\item{records}{Either \code{logical(1)} indicating if records data should be
purged from the project; or a \code{data.frame} for restoring records
data via \code{importRecords}}

\item{purge_all}{\code{logical(1)}. A shortcut option to purge all
data elements from a project.}

\item{flush}{\code{logical(1)}. When \code{TRUE}, all caches in the connection
object will be flushed after completing the operation. This is highly
recommended.}

\item{project_information}{\code{data.frame} for restoring data. Provides the
project settings to load via \code{importProjectInformation}.}

\item{meta_data}{A \code{data.frame} for restoring metadata
data via \code{importMetaData}. The API does not support deleting
metadata, but an import replaces the existing metadata.}

\item{mappings}{A \code{data.frame} for restoring instrument-event mappings
via \code{importMappings}. The API does not support deleting
mappings, but an import replaces the existing mappings.}

\item{repeating_instruments}{A \code{data.frame} for restoring repeating instruments
configuration via \code{\link[=importRepeatingInstrumentsEvents]{importRepeatingInstrumentsEvents()}}. The API does not support deleting
repeating instruments, but an import replaces the existing instruments.
NOT YET IMPLEMENTED}

\item{user_role_assignments}{A \code{data.frame} for restoring user-role
assignments via \code{importUserRoleAssignments}. The API does not support deleting
assignments, but an import replaces the existing assignments. NOT YET IMPLEMENTED.}

\item{dag_assignments}{A \code{data.frame} for restoring DAG
assignments via \code{importDagAssignments}. The API does not support deleting
assignments, but an import replaces the existing assignments. NOT YET IMPLEMENTED.}
}
\description{
These functions are primarily intended to assist with testing
features of \code{redcapAPI}. Purging and restoring project data permits
us to perform tests on different project structures without having to
manage multiple projects or API tokens.

When purging project data, many of these actions may
only be performed with a project in development status, as they are
potentially destructive and may result in data loss. It is a good
practice to back up your data and project structure before purging
a project.
}
\details{
When restoring a project, all arguments are optional. Any argument
that is \code{NULL} will result in no import being made. The order of
reconstructing the project is (purging data occurs in the reverse order):
\enumerate{
\item Update project information
\item Import Arms Data
\item Import Events Data
\item Import Meta Data
\item Import Mappings
\item Import Repeating Instruments
\item Import Users
\item Import User Roles
\item Import User-Role Assignments
\item Import Data Access Groups
\item Import Data Access Group Assignments
\item Import Records
}
}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())
             
# Preserve a project
preserveProject(rcon)

# Purge a project
purgeProject(rcon, 
             purge_all = TRUE)
                
# Restore a project
restoreProject(rcon)

}

}
