% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pop_overlap.R
\name{redist.dist.pop.overlap}
\alias{redist.dist.pop.overlap}
\title{Compare the Population Overlap Across Plans at the District Level}
\usage{
redist.dist.pop.overlap(plan_old, plan_new, total_pop, normalize_rows = TRUE)
}
\arguments{
\item{plan_old}{The reference or original plan to compare against}

\item{plan_new}{The new plan to compare to the reference plan}

\item{total_pop}{The total population by precinct This can also take a redist_map
object and will use the population in that object. If nothing is provided, it weights
all entries in plan equally.}

\item{normalize_rows}{Default TRUE. Normalize populations by row. If FALSE,
normalizes by column. If NULL, does not normalize.}
}
\value{
matrix with length(unique(plan_old)) rows and length(unique(plan_new)) columns
}
\description{
This implements Crespin's 2005 measure of district continuity, as applied to
the geographies represented by a plan, typically precincts or voting districts.
This implementation assumes none of the precincts in plan_old or plan_new are
split.
}
\examples{
set.seed(5)
data(iowa)
iowa_map <- redist_map(iowa, total_pop = pop, pop_tol = 0.01, ndists = 4)
plans <- redist_smc(iowa_map, 2)
plans_mat <- get_plans_matrix(plans)
ov <- redist.dist.pop.overlap(plans_mat[, 1], plans_mat[, 2], iowa_map)
round(ov, 2)

ov_col <- redist.dist.pop.overlap(plans_mat[, 1], plans_mat[, 2], iowa_map, normalize_rows = FALSE)
round(ov_col, 2)

ov_un_norm <- redist.dist.pop.overlap(plans_mat[, 1], plans_mat[, 2],
iowa_map, normalize_rows = NULL)
round(ov_un_norm, 2)

iowa_map_5 <- iowa_map <- redist_map(iowa, total_pop = pop, pop_tol = 0.01, ndists = 5)
plan_5 <- get_plans_matrix(redist_smc(iowa_map_5, 1))
ov4_5 <- redist.dist.pop.overlap(plans_mat[, 1], plan_5, iowa_map)
round(ov4_5, 2)

}
\references{
"Using Geographic Information Systems to Measure District Change, 2000-02",
Michael Crespin, Political Analysis (2005) 13(3): 253-260
}
