% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algoInvHist.R
\name{findMainPeak}
\alias{findMainPeak}
\title{Helper function to find the main peak of a distribution}
\usage{
findMainPeak(x, ab, mStart, withHeight = FALSE, prevPeak = NULL)
}
\arguments{
\item{x}{(numeric) vector of data points}

\item{ab}{(numeric) vector specifying the lower and higher truncation limit of density estimation}

\item{mStart}{(integer) specifying the width of the smoothing kernel(s) used for density estimation}

\item{withHeight}{(logical) specifying if only the area under the curve (FALSE) or a combination of AUC and peak height (TRUE) should be used
to detect the main peak}

\item{prevPeak}{(numeric) specifying the modEst of the previously estimated peak}
}
\value{
(list) with the two numeric values peakInd, modEst, and a density list
}
\description{
The function uses a combination of the area under the curve between valleys and the peak height to detect the main peak.
}
\author{
Tatjana Ammer \email{tatjana.ammer@roche.com}
}
