% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loss_h.R
\name{loss_h}
\alias{loss_h}
\title{Loss function for registration step optimization}
\usage{
loss_h(
  Y,
  Theta_h,
  mean_coefs,
  knots,
  beta.inner,
  family,
  t_min,
  t_max,
  parametric_warps = FALSE
)
}
\arguments{
\item{Y}{vector of observed points.}

\item{Theta_h}{B-spline basis for inverse warping functions.}

\item{mean_coefs}{spline coefficient vector for mean curve.}

\item{knots}{knot locations for B-spline basis used to estimate mean and FPC basis function.}

\item{beta.inner}{spline coefficient vector to be estimated for warping function h.}

\item{family}{\code{gaussian} or \code{binomial}.}

\item{t_min}{minimum value to be evaluated on the time domain.}

\item{t_max}{maximum value to be evaluated on the time domain.}

\item{parametric_warps}{If FALSE (default), inverse warping functions are 
estimated nonparametrically. If 'beta_cdf', they are assumed to have the form of a 
Beta(a,b) CDF. If 'piecewise' they follow a piecewise parameterized function.}
}
\value{
The scalar value taken by the loss function.
}
\description{
Loss function for registration step optimization
}
