% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REGModelList.R
\name{REGModelList}
\alias{REGModelList}
\title{R6 class representing a list of regression model}
\description{
Contains fields storing data and methods to build, process and visualize
a list of regression model.
Currently, this class is designed for CoxPH and GLM regression models.
}
\examples{
ml <- REGModelList$new(
  data = mtcars,
  y = "mpg",
  x = c("factor(cyl)", colnames(mtcars)[3:5]),
  covars = c(colnames(mtcars)[8:9], "factor(gear)")
)
ml
ml$print()
ml$plot_forest()

ml$build(f = "gaussian")
\dontrun{
ml$build(f = "gaussian", parallel = TRUE)
}
ml$print()
ml$result
ml$forest_data
ml$plot_forest()
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{data}}{a \code{data.table} storing modeling data.}

\item{\code{x}}{focal variables (terms).}

\item{\code{y}}{predicted variables or expression.}

\item{\code{covars}}{covariables.}

\item{\code{mlist}}{a list of \code{REGModel}.}

\item{\code{args}}{other arguments used for building model.}

\item{\code{type}}{model type (class).}

\item{\code{result}}{model result, a object of \code{parameters_model}. Can be converted into
data.frame with \code{\link[=as.data.frame]{as.data.frame()}} or \code{\link[data.table:as.data.table]{data.table::as.data.table()}}.}

\item{\code{forest_data}}{more detailed data used for plotting forest.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{REGModelList$new()}}
\item \href{#method-build}{\code{REGModelList$build()}}
\item \href{#method-plot_forest}{\code{REGModelList$plot_forest()}}
\item \href{#method-print}{\code{REGModelList$print()}}
\item \href{#method-clone}{\code{REGModelList$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a \code{REGModelList} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{REGModelList$new(data, y, x, covars = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{a \code{data.table} storing modeling data.}

\item{\code{y}}{predicted variables or expression.}

\item{\code{x}}{focal variables (terms).}

\item{\code{covars}}{covariables.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a \code{REGModelList} R6 object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-build"></a>}}
\if{latex}{\out{\hypertarget{method-build}{}}}
\subsection{Method \code{build()}}{
Build \code{REGModelList} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{REGModelList$build(
  f = c("coxph", "binomial", "gaussian", "Gamma", "inverse.gaussian", "poisson",
    "quasi", "quasibinomial", "quasipoisson"),
  exp = NULL,
  ci = 0.95,
  parallel = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{f}}{a length-1 string specifying modeling function or family of \code{\link[=glm]{glm()}}, default is 'coxph'.
Other options are members of GLM family, see \code{\link[stats:family]{stats::family()}}.
'binomial' is logistic, and 'gaussian' is linear.}

\item{\code{exp}}{logical, indicating whether or not to exponentiate the the coefficients.}

\item{\code{ci}}{confidence Interval (CI) level. Default to 0.95 (95\%).
e.g. \code{\link[survival:coxph]{survival::coxph()}}.}

\item{\code{parallel}}{if \code{TRUE}, use N-1 cores to run the task.}

\item{\code{...}}{other parameters passing to corresponding regression model function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a \code{REGModel} R6 object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_forest"></a>}}
\if{latex}{\out{\hypertarget{method-plot_forest}{}}}
\subsection{Method \code{plot_forest()}}{
plot forest.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{REGModelList$plot_forest(
  ref_line = NULL,
  xlim = NULL,
  vars = NULL,
  p = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ref_line}}{reference line, default is \code{1} for HR.}

\item{\code{xlim}}{limits of x axis.}

\item{\code{vars}}{selected variables to show.}

\item{\code{p}}{selected variables with level' pvalue lower than p.}

\item{\code{...}}{other plot options passing to \code{\link[forestploter:forest]{forestploter::forest()}}.
Also check \url{https://github.com/adayim/forestploter} to see more complex adjustment of the result plot.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
print the \code{REGModelList} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{REGModelList$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{unused.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{REGModelList$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
