% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.reliabilitydiag}
\alias{summary.reliabilitydiag}
\title{Summarizing reliability diagrams}
\usage{
\method{summary}{reliabilitydiag}(object, ..., score = "brier")
}
\arguments{
\item{object}{an object inheriting from the class \code{'reliabilitydiag'}.}

\item{...}{further arguments to be passed to or from methods.}

\item{score}{currently only "brier" or a vectorized scoring function,
that is, \code{function(observation, prediction)}.}
}
\value{
A \code{'summary.reliability'} object, which is also a
tibble (see \code{\link[tibble:tibble]{tibble::tibble()}}) with columns:
\tabular{ll}{
   \code{forecast} \tab the name of the prediction method.\cr
   \code{mean_score} \tab the mean score of the original
     forecast values.\cr
   \code{miscalibration} \tab a measure of miscalibration
     (\emph{how reliable is the prediction method?}),
      smaller is better.\cr
   \code{discrimination} \tab a measure of discrimination
     (\emph{how variable are the recalibrated predictions?}),
     larger is better.\cr
   \code{uncertainty} \tab the mean score of a constant prediction at the
     value of the average observation.
 }
}
\description{
A summary of a reliability diagram in terms of quantitative measures of
predictive performance, miscalibration, discrimination,
and uncertainty.
}
\details{
Predictive performance is measured by the mean score of the original
forecast values, denoted by \eqn{S}.

Uncertainty, denoted by \eqn{UNC}, is the mean score of a constant
prediction at the value of the average observation.
It is the highest possible mean score of a calibrated prediction method.

Discrimination, denoted by \eqn{DSC}, is \eqn{UNC} minus the mean score
of the PAV-recalibrated forecast values.
A small value indicates a low information content (low signal) in the
original forecast values.

Miscalibration, denoted by \eqn{MCB}, is \eqn{S} minus the mean score
of the PAV-recalibrated forecast values.
A high value indicates that predictive performance of the prediction method
can be improved by recalibration.

These measures are related by the following equation,
\deqn{S = MCB - DSC + UNC.}
Score decompositions of this type have been studied extensively, but the
optimality of the PAV solution ensures that \eqn{MCB} is nonnegative,
regardless of the chosen (admissible) scoring function.
This is a unique property achieved by choosing PAV-recalibration.

If deviating from the Brier score as performance metric, make sure to choose
a proper scoring rule for binary events, or equivalently,
a scoring function with outcome space \{0, 1\} that is consistent for the
expectation functional.
}
\examples{
data("precip_Niamey_2016", package = "reliabilitydiag")
r <- reliabilitydiag(
  precip_Niamey_2016[c("Logistic", "EMOS", "ENS", "EPC")],
  y = precip_Niamey_2016$obs,
  region.level = NA
)
summary(r)
summary(r, score = function(y, x) (x - y)^2)

}
