% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clm_MI_delta.R
\name{clm_MI_delta}
\alias{clm_MI_delta}
\title{Apply Delta adjustment to Update JAGS MCMC outputs under MAR for Cumulative Logistic Model}
\usage{
clm_MI_delta(object, treatment, delta = 0, start = NULL, end = NULL,
  exclude_chains = NULL, thin = NULL, subset = FALSE,
  ord_cov_dummy = TRUE, seed = NULL, mess = FALSE, ...)
}
\arguments{
\item{object}{an object of class remiod}

\item{treatment}{the variable name of treatment. Reference level of treatment should be coded as 0.}

\item{delta}{specific value used for Delta adjustment, applicable only
for method="delta".}

\item{start}{first iteration to be used.}

\item{end}{last iteration to be used.}

\item{exclude_chains}{optional vector of numbers, indexing MCMC chains to be excluded from the output.}

\item{thin}{thinning to be applied.}

\item{subset}{subset of parameters (columns of the mcmc object) to be used.}

\item{ord_cov_dummy}{optional. specify whether ordinal variables should be treated as
categorical variables or continuous variables when they are
included as covariates in the sequential imputation models.
Default is \code{TRUE}, dummy variables will be created accordingly.}

\item{seed}{optional seed value.}

\item{mess}{logical, should messages be displayed?}

\item{...}{optional arguments pass from main function.}
}
\value{
A matrix of MCMC samples with all monitored parameters.A subset of
the MCMC sample can be selected using \code{start}, \code{end} and
\code{thin}.
}
\description{
Internal function to obtain delta-adjusted MCMC from an MAR object.
}
