% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{update}
\alias{update}
\title{Update Packages}
\usage{
update(
  packages = NULL,
  ...,
  library = NULL,
  rebuild = FALSE,
  check = FALSE,
  confirm = interactive(),
  project = NULL
)
}
\arguments{
\item{packages}{A character vector of \R packages to update. When \code{NULL},
all packages within the required libraries will be updated.}

\item{...}{Unused arguments, reserved for future expansion. If any arguments
are matched to \code{...}, \code{renv} will signal an error.}

\item{library}{The \R library to be used. When \code{NULL}, the active project
library will be used instead.}

\item{rebuild}{Force packages to be rebuilt, thereby bypassing any installed
versions of the package available in the cache? This can either be a
boolean (indicating that the requested package(s) should be rebuilt), or a
vector of package names indicating which packages should be rebuilt.}

\item{check}{Boolean; check for package updates without actually
installing available updates?}

\item{confirm}{Boolean; prompt the user before taking any action?}

\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}
}
\value{
A named list of package records which were installed by \code{renv}.
}
\description{
Update packages which are currently out-of-date. Currently, only
CRAN and GitHub package sources are supported.
}
\details{
Updates will only be checked from the same source -- for example,
if a package was installed from GitHub, but a newer version is
available on CRAN, that updated version will not be seen.
}
\examples{
\dontrun{

# update the 'dplyr' package
renv::update("dplyr")

}
}
