% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dirMM.R
\name{dir.MM}
\alias{dir.MM}
\title{Non-linear Least-squares Fitting of the MM equation}
\usage{
dir.MM(data, unit_S = 'mM', unit_v = 'au', plot = TRUE)
}
\arguments{
\item{data}{a dataframe with two columns. The first column contains the values of the independent variable (substrate concentration), and the second column contains the initial rates.}

\item{unit_S}{concentration unit.}

\item{unit_v}{time unit.}

\item{plot}{logical. If true, the data and fitted curve are plotted.}
}
\value{
A list of two elements. The first one is a vector containing the enzyme kinetic parameters. The second one is a dataframe with the original data plus the fitted value of v.
}
\description{
Non-linear least-squares fitting of the Michaelis-Menten equation.
}
\details{
This function invokes nls() to carry out the fitting.
}
\examples{
dir.MM(ONPG[, c(1,2)])
}
