% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Progress.R
\name{fE.progress}
\alias{fE.progress}
\title{Fitted Progress Curve for Enzyme-Catalyzed Reaction}
\usage{
fE.progress(data, unit_S = 'mM', unit_t = 'min')
}
\arguments{
\item{data}{a dataframe where the first column is the time and the second column is the substrate concentration.}

\item{unit_S}{concentration unit.}

\item{unit_t}{time unit.}
}
\value{
Returns a list with two elements. The first one contains the fitted kinetic parameters, the second one is a dataframe giving the fitted substrate concentration time course.
}
\description{
Fits the progress curve of an enzyme-catalyzed reaction.
}
\examples{
data <- sE.progress(So = 10, time = 5, Km = 4, Vm = 50, plot = FALSE)
fE.progress(data[, c(1,3)])
}
\references{
Biochem Mol Biol Educ.39:117-25 (10.1002/bmb.20479).
}
\seealso{
sEprogress(), int.MM()
}
