% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ltransf.R
\name{lb}
\alias{lb}
\title{Lineweaver-Burk Transformation}
\usage{
lb(data, unit_S = 'mM', unit_v = 'au', weighting = FALSE, plot = TRUE)
}
\arguments{
\item{data}{a dataframe where the first column is the independent variable, [S], and the remaining columns (as many as experiment replicates) correspond to the dependent variable, v.}

\item{unit_S}{concentration unit.}

\item{unit_v}{time unit.}

\item{weighting}{logical. When TRUE the weight v^4 is employed.}

\item{plot}{logical. If TRUE the data and fitted line are plotted.}
}
\value{
A double reciprocal plot and the Km and Vm computed using averaged 1/v (when more than one replicate is provided). In addition, this function returns a list of five elements. The first and second ones are vectors with the Km and Vm, respectively, computed individually for each replicate. The third one provides the R-squared values of the fits. The fourth element of the list gives the fitted Km and Vm. The last element of the list is a dataframe with the values of the transformed variables.
}
\description{
Obtains Km and Vm using double reciprocal transformation
}
\examples{
lb(ONPG[, c(1,2)], weighting = TRUE)
}
\references{
J. Am. Chem. Soc.1934, 56, 3,658-666 (doi.org/10.1021/ja01318a036)
}
\seealso{
hw(), eh(), ecb()
}
