% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupedApply.R
\name{replyr_split}
\alias{replyr_split}
\title{split a data item by values in a column.}
\usage{
replyr_split(df, gcolumn, ..., ocolumn = NULL, decreasing = FALSE,
  partitionMethod = "extract", maxgroups = 100, eagerCompute = FALSE)
}
\arguments{
\item{df}{remote dplyr data item}

\item{gcolumn}{grouping column}

\item{...}{force later values to be bound by name}

\item{ocolumn}{ordering column (optional)}

\item{decreasing}{if TRUE sort in decreasing order by ocolumn}

\item{partitionMethod}{method to partition the data, one of 'split' (only works over local data frames), or 'extract'}

\item{maxgroups}{maximum number of groups to work over}

\item{eagerCompute}{if TRUE call compute on split results}
}
\value{
list of data items
}
\description{
Partitions from by values in grouping column, and returns list.  Only advised for a
moderate number of groups and better if grouping column is an index.
This plus lapply and replyr::bind_rows is powerfull
enough to implement "The Split-Apply-Combine Strategy for Data Analysis"
https://www.jstatsoft.org/article/view/v040i01
}
\examples{

library('dplyr')
d <- data.frame(group=c(1,1,2,2,2),
                order=c(.1,.2,.3,.4,.5),
                values=c(10,20,2,4,8))
d \%>\% replyr_split('group')

}
