% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inTest.R
\name{replyr_inTest}
\alias{replyr_inTest}
\title{Product a column noting if another columns values are in a given set.}
\usage{
replyr_inTest(x, cname, values, nname, ...,
  tempNameGenerator = makeTempNameGenerator("replyr_inTest"),
  verbose = TRUE)
}
\arguments{
\item{x}{tbl or item that can be coerced into such.}

\item{cname}{name of the column to test values of.}

\item{values}{set of values to check set membership of.}

\item{nname}{name for new column}

\item{...}{force later parameters to bind by name}

\item{tempNameGenerator}{temp name generator produced by replyr::makeTempNameGenerator, used to record dplyr::compute() effects.}

\item{verbose}{logical if TRUE echo warnings}
}
\value{
table with membership indications.
}
\description{
Product a column noting if another columns values are in a given set.
}
\examples{

values <- c('a','c')
d <- data.frame(x=c('a','a','b',NA,'c','c'),y=1:6,
                stringsAsFactors=FALSE)
replyr_inTest(d,'x',values,'match')

}
