% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_rows.R
\name{bind_rowsQ}
\alias{bind_rowsQ}
\title{Bind rows by a query. Assumes all tables structured identically.}
\usage{
bind_rowsQ(tableNames, colNames, my_db,
  tempNameGenerator = makeTempNameGenerator("bind_rowsQ"), ...,
  origTableColumn = NULL)
}
\arguments{
\item{tableNames}{names of tables to concatinate (not empty)}

\item{colNames}{names of columns}

\item{my_db}{connection to where tables live}

\item{tempNameGenerator}{temp name generator produced by replyr::makeTempNameGenerator, used to record dplyr::compute() effects.}

\item{...}{force later arguments to bind by name}

\item{origTableColumn}{character, column to put original table name in.}
}
\description{
Bind rows by a query. Assumes all tables structured identically.
}
\examples{

my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
tempNameGenerator = makeTempNameGenerator("bind_rowsQ_demo")
d1 <- replyr_copy_to(my_db, data.frame(x=1:2, y= 10:11), 'd1')
d2 <- replyr_copy_to(my_db, data.frame(x=3:4, y= 13:14), 'd2')
bind_rowsQ(c('d1', 'd2'), c('x', 'y'), my_db,
           tempNameGenerator = tempNameGenerator,
           origTableColumn = 'orig_table')

}
