% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repoS3.R
\name{repo_bulkedit}
\alias{repo_bulkedit}
\title{Edit all items info using a text file.}
\usage{
repo_bulkedit(rp, outfile = NULL, infile = NULL)
}
\arguments{
\item{rp}{An object of class repo.}

\item{outfile}{Name of a file to put entries data to.}

\item{infile}{Name of a file to read entries data from.}
}
\value{
Used for side effects.
}
\description{
Edit all items info using a text file.
}
\details{
Exactly one of \code{outfile} or \code{infile} must be
    supplied. All repository entry fields are copied to a
    tab-separated file when using the \code{outfile} parameter. All
    repo entries are updated reading from \code{infile} when the
    \code{infile} parameter is used. Within the TAGS field, tags
    must be comma-separated. The system writes a checksum to the
    \code{outfile} that prevents from using it as \code{infile} if
    repo has changed in the meantime.
}
\examples{
rp_path <- file.path(tempdir(), "example_repo")
rp <- repo_open(rp_path, TRUE)
rp$put(1, "item1", "Sample item 1", c("tag1", "tag2"))

items_data_file <- tempfile()
rp$bulkedit(items_data_file)
## Manually edit items_data_file, then update items:
rp$bulkedit(infile=items_data_file)

## wiping temporary repo
unlink(rp_path, TRUE)
}
\seealso{
repo_set
}

