% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repoS3.R
\name{repo_copy}
\alias{repo_copy}
\title{Copy items to another repository}
\usage{
repo_copy(rp, destrepo, name, tags = NULL)
}
\arguments{
\item{rp}{An object of class repo (will copy from it)}

\item{destrepo}{An object of class repo (will copy to it)}

\item{name}{The name (or list of names) of the item/s to copy}

\item{tags}{If not NULL, copy all items matching tags.}
}
\value{
Used for side effects.
}
\description{
Copies an object file from one repository to another and creates a new entry
in the index of the destination repository. Supports tags and multiple names.
}
\examples{
## Repository creation
rp_path1 <- file.path(tempdir(), "example_repo1")

rp1 <- repo_open(rp_path1, TRUE)
rp1$put(0, "item1", "A sample item", "tag1")
rp_path2 <- file.path(tempdir(), "example_repo2")
rp2 <- repo_open(rp_path2, TRUE)
rp1$copy(rp2, "item1")

## wiping temporary repo
unlink(rp_path1, TRUE)
unlink(rp_path2, TRUE)
}

