% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo_public.R
\name{repo_pull}
\alias{repo_pull}
\title{Download item remote content}
\usage{
repo_pull(name, replace = F)
}
\arguments{
\item{name}{Name of the existing item that will be updated.}

\item{replace}{If TRUE, existing item's object is overwritten.}
}
\value{
Used for side effects.
}
\description{
Download item remote content
}
\details{
Repo index files can be used as pointers to remote
    data. The pull function will download the actual data from the
    Internet, including regular items or attachment. Another use of
    the URL item's parameter is to attach a remote resource without
    downloading it.
}
\examples{
## Repository creation
rp_path <- file.path(tempdir(), "example_repo")
rp <- repo_open(rp_path, TRUE)
remote_URL <- paste0("https://github.com/franapoli/repo/blob/",
                     "untested/inst/remote_sample.RDS?raw=true")

## The following item will have remote source
rp$put("Local content", "item1", "Sample item 1", "tag",
         URL = remote_URL)
print(rp$get("item1"))

## suppressWarnings(try(rp$pull("item1"), TRUE))
 tryCatch(rp$pull("item1"),
         error = function(e)
             message("There were warnings whle accessing remote content"),
         warning = function(w)
             message("Could not download remote content")
         )
print(rp$get("item1"))

## wiping temporary repo
unlink(rp_path, TRUE)
}
