% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{calculatePhat}
\alias{calculatePhat}
\title{calculatePhat}
\usage{
calculatePhat(x, y, alpha = 0.05, sigfig = -1)
}
\arguments{
\item{x}{is a vector of values from group 1}

\item{y}{is a vector of values from group 2}

\item{alpha}{is the Type 1 error level for statistical tests}

\item{sigfig}{If sigfig>0 the data in x and y is truncated to the specified number of significant digits.}
}
\value{
list including the value of the t-test for PHat, the estimate of PHat and Cliff's d, and the confidence intervals for PHat.
}
\description{
This function extract the probability of superiority (i.e., Phat) and its confidence interval based on Brunner and Munzel (2000) heteroscedastic analog of WMW test. It is based on Wilcox'x bmp function with some amendments. It does not include a plotit facility. It uses the smallest non-zero variance to idetify confidence intervals and statistical significance for values of Phat=0 and Phat=1. It ensure that confidence intervals do not take on invalid values such as values <0 or >1.
}
\examples{
x=c(1.2, 3.0, 2.2, 4.0, 2.5, 3.0)
y=c(3,4.2,4,6,7,5.9)
calculatePhat(x,y)
# $test.stat
# [1] 6.381249
# $phat
# [1] 0.9305556
# $dhat
# [1] 0.8611111
# $sig.level
# [1] 0.0001191725
# $s.e.
# [1] 0.06747199
# $ci.p
# [1] 0.7783001 1.0000000
# $df
# [1] 9.148489
# Another example:
z=c(1,2,3,4)
y=c(5,6,7,8)
calculatePhat(z,y)
# $test.stat
# [1] 10.6066
# $phat
# [1] 1
# $dhat
# [1] 1
# $sig.level
# [1] 4.135921e-05
# $s.e.
# [1] 0.04419417
# $ci.p
# [1] 0.8918608 1.0000000
# $df
# [1] 6
}
\author{
Rand Wilcox amendments by Barbara Kitchenham and Lech Madeyski
}
