% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache-tools.R
\name{getUserTags}
\alias{getUserTags}
\alias{getCacheId}
\alias{getArtifact}
\title{Cache helpers}
\usage{
getUserTags(cacheRepo, shownCache, cacheId, concatenated = TRUE)

getCacheId(cacheRepo, shownCache, artifact)

getArtifact(cacheRepo, shownCache, cacheId)
}
\arguments{
\item{cacheRepo}{A repository used for storing cached objects.
This is optional if \code{Cache} is used inside a SpaDES module.}

\item{shownCache}{Primary way of supplying \code{cacheRepo}; the data.table obj
resulting from \code{showCache}, i.e., it will override \code{cacheRepo}.
If this and \code{cacheRepo} are missing, then it will default to
\code{getOption('reproducible.cachePath')}}

\item{cacheId}{A character vector of o cacheId values to use in the cache}

\item{concatenated}{Logical. If \code{TRUE}, the returned userTags will
be concatenated tagKey:tagValue}

\item{artifact}{Character vector of artifact values in the
\code{artifact} column of \code{showCache}}
}
\value{
\code{getCacheId} returns the \code{cacheId} values for 1 or more
artifacts in the cache.

\code{getArtifact} returns the \code{artifact} value for 1 or more
entries in the cache, by \code{cacheId}.
}
\description{
A few helpers to get specific things from the cache repository
}
