% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postProcess.R
\name{fixErrors}
\alias{fixErrors}
\alias{fixErrors.default}
\alias{fixErrors.Raster}
\alias{fixErrors.SpatialPolygons}
\alias{fixErrors.sf}
\title{Do some minor error fixing}
\usage{
fixErrors(
  x,
  objectName,
  attemptErrorFixes = TRUE,
  useCache = getOption("reproducible.useCache", FALSE),
  verbose = getOption("reproducible.verbose", 1),
  ...
)

\method{fixErrors}{default}(
  x,
  objectName,
  attemptErrorFixes = TRUE,
  useCache = getOption("reproducible.useCache", FALSE),
  verbose = getOption("reproducible.verbose", 1),
  ...
)

\method{fixErrors}{Raster}(
  x,
  objectName,
  attemptErrorFixes = TRUE,
  useCache = getOption("reproducible.useCache", FALSE),
  verbose = getOption("reproducible.verbose", 1),
  ...
)

\method{fixErrors}{SpatialPolygons}(
  x,
  objectName = NULL,
  attemptErrorFixes = TRUE,
  useCache = getOption("reproducible.useCache", FALSE),
  verbose = getOption("reproducible.verbose", 1),
  ...
)

\method{fixErrors}{sf}(
  x,
  objectName = NULL,
  attemptErrorFixes = TRUE,
  useCache = getOption("reproducible.useCache", FALSE),
  verbose = getOption("reproducible.verbose", 1),
  ...
)
}
\arguments{
\item{x}{A \code{SpatialPolygons*} or \code{sf} object.}

\item{objectName}{Optional. This is only for messaging; if provided, then messages relayed
to user will mention this.}

\item{attemptErrorFixes}{Will attempt to fix known errors. Currently only some failures
for \code{SpatialPolygons*} are attempted.
Notably with \code{raster::buffer(..., width = 0)}.
Default \code{TRUE}, though this may not be the right action for all cases.}

\item{useCache}{Logical, default \code{getOption("reproducible.useCache", FALSE)}, whether
Cache is used on the internal \code{raster::buffer} command.}

\item{...}{Passed to methods. None currently implemented.}
}
\description{
These must be very common for this function to be useful. Currently, the only
meaningful method is on \code{SpatialPolygons}, and it runs \code{sf::st_is_valid}.
If \code{FALSE}, then it runs a buffer of width 0.

This uses \code{raster::buffer(..., width = 0)} internally, which fixes some
failures to \code{sf::st_is_valid}
}
\examples{
# Add a study area to Crop and Mask to
# Create a "study area"
library(sp)
library(raster)
ow <- setwd(tempdir())

# make a SpatialPolygon
coords1 <- structure(c(-123.98, -117.1, -80.2, -100, -123.98, 60.9, 67.73, 65.58, 51.79, 60.9),
                     .Dim = c(5L, 2L))
Sr1 <- Polygon(coords1)
Srs1 <- Polygons(list(Sr1), "s1")
shpEcozone <- SpatialPolygons(list(Srs1), 1L)
crs(shpEcozone) <- "+proj=longlat +datum=WGS84 +no_defs +ellps=WGS84 +towgs84=0,0,0"

# make a "study area" that is subset of larger dataset
coords <- structure(c(-118.98, -116.1, -99.2, -106, -118.98, 59.9, 65.73, 63.58, 54.79, 59.9),
                    .Dim = c(5L, 2L))
Sr1 <- Polygon(coords)
Srs1 <- Polygons(list(Sr1), "s1")
StudyArea <- SpatialPolygons(list(Srs1), 1L)
crs(StudyArea) <- "+proj=longlat +datum=WGS84 +no_defs +ellps=WGS84 +towgs84=0,0,0"

##########
shpEcozonePostProcessed <- postProcess(shpEcozone, studyArea = StudyArea)

# Try manually, individual pieces
shpEcozoneReprojected <- projectInputs(shpEcozone, StudyArea)
shpEcozoneCropped <- cropInputs(shpEcozone, StudyArea)
shpEcozoneClean <- fixErrors(shpEcozone)
shpEcozoneMasked <- maskInputs(shpEcozone, StudyArea)

setwd(ow)
}
\keyword{internal}
