% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showCacheEtc.R
\name{showCache}
\alias{showCache}
\alias{clearCache}
\alias{clearCache,ANY-method}
\alias{cc}
\alias{showCache,ANY-method}
\alias{keepCache}
\alias{keepCache,ANY-method}
\title{Examining and modifying the cache}
\usage{
clearCache(
  x,
  userTags = character(),
  after = NULL,
  before = NULL,
  fun = NULL,
  cacheId = NULL,
  ask = getOption("reproducible.ask"),
  useCloud = FALSE,
  cloudFolderID = getOption("reproducible.cloudFolderID", NULL),
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  verbose = getOption("reproducible.verbose"),
  ...
)

\S4method{clearCache}{ANY}(
  x,
  userTags = character(),
  after = NULL,
  before = NULL,
  fun = NULL,
  cacheId = NULL,
  ask = getOption("reproducible.ask"),
  useCloud = FALSE,
  cloudFolderID = getOption("reproducible.cloudFolderID", NULL),
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  verbose = getOption("reproducible.verbose"),
  ...
)

cc(secs, ..., verbose = getOption("reproducible.verbose"))

showCache(
  x,
  userTags = character(),
  after = NULL,
  before = NULL,
  fun = NULL,
  cacheId = NULL,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  verbose = getOption("reproducible.verbose"),
  ...
)

\S4method{showCache}{ANY}(
  x,
  userTags = character(),
  after = NULL,
  before = NULL,
  fun = NULL,
  cacheId = NULL,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  verbose = getOption("reproducible.verbose"),
  ...
)

keepCache(
  x,
  userTags = character(),
  after = NULL,
  before = NULL,
  ask = getOption("reproducible.ask"),
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  verbose = getOption("reproducible.verbose"),
  ...
)

\S4method{keepCache}{ANY}(
  x,
  userTags = character(),
  after = NULL,
  before = NULL,
  ask = getOption("reproducible.ask"),
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  verbose = getOption("reproducible.verbose"),
  ...
)
}
\arguments{
\item{x}{A simList or a directory containing a valid Cache repository. Note:
For compatibility with \code{Cache} argument, \code{cachePath} can also be
used instead of \code{x}, though \code{x} will take precedence.}

\item{userTags}{Character vector. If used, this will be used in place of the
\code{after} and \code{before}.
Specifying one or more \code{userTag} here will clear all
objects that match those tags.
Matching is via regular expression, meaning partial matches
will work unless strict beginning (\code{^}) and end (\code{$}) of string
characters are used.
Matching will be against any of the 3 columns returned by \code{showCache()},
i.e., \code{artifact}, \code{tagValue} or \code{tagName}.
Also, if \code{length(userTags) > 1}, then matching is by \code{and}.
For \code{or} matching, use \code{|} in a single character string.
See examples.}

\item{after}{A time (POSIX, character understandable by data.table).
Objects cached after this time will be shown or deleted.}

\item{before}{A time (POSIX, character understandable by data.table).
Objects cached before this time will be shown or deleted.}

\item{fun}{An optional character vector describing the function name to extract.
Only functions with this/these functions will be returned.}

\item{cacheId}{An optional character vector describing the \code{cacheId}s to extract.
Only entries with this/these \code{cacheId}s will be returned. If \code{useDBI(FALSE)},
this will also be dramatically faster than using \code{userTags}, for a large
cache.}

\item{ask}{Logical. If \code{FALSE}, then it will not ask to confirm deletions using
\code{clearCache} or \code{keepCache}. Default is \code{TRUE}}

\item{useCloud}{Logical. If \code{TRUE}, then every object that is deleted locally will
also be deleted in the \code{cloudFolderID}, if it is non-\code{NULL}}

\item{cloudFolderID}{A googledrive dribble of a folder, e.g., using \code{drive_mkdir()}.
If left as \code{NULL}, the function will create a cloud folder with name from last
two folder levels of the \code{cachePath} path, :
\code{paste0(basename(dirname(cachePath)), "_", basename(cachePath))}.
This \code{cloudFolderID} will be added to \code{options("reproducible.cloudFolderID")},
but this will not persist across sessions. If this is a character string, it will
treat this as a folder name to create or use on GoogleDrive.}

\item{drv}{if using a database backend, drv must be an object that
inherits from DBIDriver e.g., from package RSQLite, e.g., SQLite}

\item{conn}{an optional DBIConnection object, as returned by dbConnect().}

\item{verbose}{Numeric, -1 silent (where possible), 0 being very quiet,
1 showing more messaging, 2 being more messaging, etc.
Default is 1. Above 3 will output much more information about the internals of
Caching, which may help diagnose Caching challenges. Can set globally with an
option, e.g., \verb{options('reproducible.verbose' = 0) to reduce to minimal}}

\item{...}{Other arguments. Can be in the form of \code{tagKey = tagValue}, such as,
\code{class = "numeric"} to find all entries that are numerics in the cache.
Note: the special cases of \code{cacheId} and \code{fun} have their own
named arguments in these functions.
Also can be \code{regexp = xx}, where \code{xx} is \code{TRUE} if the user
is passing a regular expression.
Otherwise, \code{userTags} will need to be exact matches. Default is
missing, which is the same as \code{TRUE}. If there are errors due
to regular expression problem, try \code{FALSE}. For \code{cc}, it is
passed to \code{clearCache}, e.g., \code{ask}, \code{userTags}. For \code{showCache},
it can also be \code{sorted = FALSE} to return the object unsorted.}

\item{secs}{Currently 3 options: the number of seconds to pass to \code{clearCache(after = secs)},
a \code{POSIXct} time e.g., from \code{Sys.time()}, or missing. If missing,
the default, then it will delete the most recent entry in the Cache.}
}
\value{
Will clear all objects (or those that match \code{userTags}, or those
between \code{after} or \code{before}) from the repository located at
\code{cachePath} of the sim object, if \code{sim} is provided, or located in
\code{cachePath}.
Invisibly returns a \code{data.table} of the removed items.
}
\description{
These are convenience wrappers around \code{DBI} package functions.
They allow the user a bit of control over what is being cached.
}
\details{
If neither \code{after} or \code{before} are provided, nor \code{userTags},
then all objects will be removed.
If both \code{after} and \code{before} are specified, then all objects between
\code{after} and \code{before} will be deleted.
If \code{userTags} is used, this will override \code{after} or \code{before}.

\code{cc(secs)} is just a shortcut for \code{clearCache(repo = currentRepo, after = secs)},
i.e., to remove any cache entries touched in the last \code{secs} seconds. Since, \code{secs}
can be missing, this is also be a shorthand for "remove most recent entry from
the cache".

\describe{
\item{\code{clearCache}}{remove items from the cache based on their
\code{userTag} or \code{times} values.}
\item{\code{keepCache}}{remove all cached items \emph{except} those based on
certain \code{userTags} or \code{times} values.}
\item{\code{showCache}}{display the contents of the cache.}
}

By default the return of \code{showCache} is sorted by \code{cacheId}. For convenience,
a user can optionally have it unsorted (passing \code{sorted = FALSE}),
which may be noticeably faster when
the cache is large (\verb{> 1e4} entries).
}
\note{
If the cache is larger than 10MB, and clearCache is used, there will be
a message and a pause, if interactive, to prevent accidentally deleting of a
large cache repository.
}
\examples{
data.table::setDTthreads(2)

tmpDir <- file.path(tempdir(), "reproducible_examples", "Cache")
try(clearCache(tmpDir, ask = FALSE), silent = TRUE) # just to make sure it is clear

# Basic use
ranNumsA <- Cache(rnorm, 10, 16, cachePath = tmpDir)

# All same
ranNumsB <- Cache(rnorm, 10, 16, cachePath = tmpDir) # recovers cached copy
ranNumsD <- Cache(quote(rnorm(n = 10, 16)), cachePath = tmpDir) # recovers cached copy

# Any minor change makes it different
ranNumsE <- Cache(rnorm, 10, 6, cachePath = tmpDir) # different

## Example 1: basic cache use with tags
ranNumsA <- Cache(rnorm, 4, cachePath = tmpDir, userTags = "objectName:a")
ranNumsB <- Cache(runif, 4, cachePath = tmpDir, userTags = "objectName:b")
ranNumsC <- Cache(runif, 40, cachePath = tmpDir, userTags = "objectName:b")

showCache(tmpDir, userTags = c("objectName"))
showCache(tmpDir, userTags = c("^a$")) # regular expression ... "a" exactly

# Fine control of cache elements -- pick out only the large runif object, and remove it
cache1 <- showCache(tmpDir, userTags = c("runif")) # show only cached objects made during runif
toRemove <- cache1[tagKey == "object.size"][as.numeric(tagValue) > 700]$cacheId
clearCache(tmpDir, userTags = toRemove, ask = FALSE)
cacheAfter <- showCache(tmpDir, userTags = c("runif")) # Only the small one is left

data.table::setDTthreads(2)
tmpDir <- file.path(tempdir(), "reproducible_examples", "Cache")
try(clearCache(tmpDir, ask = FALSE), silent = TRUE) # just to make sure it is clear

Cache(rnorm, 1, cachePath = tmpDir)
thisTime <- Sys.time()
Cache(rnorm, 2, cachePath = tmpDir)
Cache(rnorm, 3, cachePath = tmpDir)
Cache(rnorm, 4, cachePath = tmpDir)
showCache(x = tmpDir) # shows all 4 entries
cc(ask = FALSE, x = tmpDir)
showCache(x = tmpDir) # most recent is gone
cc(thisTime, ask = FALSE, x = tmpDir)
showCache(x = tmpDir) # all those after thisTime gone, i.e., only 1 left
cc(ask = FALSE, x = tmpDir) # Cache is
cc(ask = FALSE, x = tmpDir) # Cache is already empty
}
\seealso{
\code{\link[=mergeCache]{mergeCache()}}. Many more examples in \code{\link[=Cache]{Cache()}}.
}
