% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specta_data_processing.R
\name{compute_sea_state_1d_spectrum}
\alias{compute_sea_state_1d_spectrum}
\title{Compute sea_state parameter from wave spectrum}
\usage{
compute_sea_state_1d_spectrum(spec, ...)
}
\arguments{
\item{spec}{1D spectrum data, e.g. from \code{get_1Dspectrum}}

\item{...}{currently unused}
}
\value{
a tibble with the sea-state parameters computed from the time series of 2D spectrum
}
\description{
Compute sea_state parameter from wave spectrum
}
\examples{
# Ensure that data package is available before running the example.
#  If it is not, see the `resourcecode` package vignette for details
# on installing the required data package.
if (requireNamespace("resourcecodedata", quietly = TRUE)) {
rscd_params <- get_parameters(
  node = "134865",
  start = "1994-01-01",
  end = "1994-01-31 23:00:00",
  parameters = c("hs", "tp", "cge", "t01", "dp", "dir")
)
spec <- resourcecodedata::rscd_1d_spectra
param_calc <- compute_sea_state_1d_spectrum(spec)
oldpar <- par(mfcol = c(2, 2))
plot(param_calc$time, param_calc$hs, type = "l", xlab = "Time", ylab = "Hs (m)")
lines(rscd_params$time, rscd_params$hs, col = "red")
plot(param_calc$time, param_calc$cge, type = "l", xlab = "Time", ylab = "CgE (kW/m)")
lines(rscd_params$time, rscd_params$cge, col = "red")
plot(param_calc$time, param_calc$tp, type = "l", xlab = "Time", ylab = "Tp (s)")
lines(rscd_params$time, rscd_params$tp, col = "red")
plot(param_calc$time, param_calc$dp, type = "l", xlab = "Time", ylab = "Peak direction (°)")
lines(rscd_params$time, rscd_params$dp, col = "red")
par(oldpar)
}
}
