% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specta_data_processing.R
\name{dispersion}
\alias{dispersion}
\title{Compute the dispersion relation of waves
Find \emph{k} s.t. (2.pi.f)^2 = g.k.tanh(k.d)}
\usage{
dispersion(frequencies, depth, iter_max = 200, tol = 1e-06)
}
\arguments{
\item{frequencies}{frequency vector}

\item{depth}{depth (m)}

\item{iter_max}{maximum number of iterations in the solver}

\item{tol}{tolerance for termination.}
}
\value{
the wave numbers (same size as frequencies)
}
\description{
Compute the dispersion relation of waves
Find \emph{k} s.t. (2.pi.f)^2 = g.k.tanh(k.d)
}
\examples{
freq <- seq(from = 0, to = 1, length.out = 100)
k1 <- dispersion(freq, depth = 1)
k10 <- dispersion(freq, depth = 10)
kInf <- dispersion(freq, depth = Inf)
plot(freq, k1, type = "l")
lines(freq, k10, col = "red")
lines(freq, kInf, col = "green")
}
