% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_eurostat_dsd.R
\name{search_eurostat_dsd}
\alias{search_eurostat_dsd}
\title{Search for pattern in the Data Structure Definition of a dataset}
\usage{
search_eurostat_dsd(pattern, dsd = NULL, name = TRUE, exact_match = FALSE, ...)
}
\arguments{
\item{pattern}{a character string or a vector of character string.}

\item{dsd}{a table containing Data Structure Definition (DSD) of a Eurostat dataset which can be retreived by the \code{\link{get_eurostat_dsd}} function.}

\item{name}{a boolean with the default value \code{TRUE}, if the search shall look for the pattern in the name of the code.
If the value \code{FALSE}, then only the 'code' column of the DSD will be  searched.}

\item{exact_match}{a boolean with the default value \code{FALSE}, if the strings provided in \code{pattern} shall be matched exactly as it is or as a pattern.}

\item{...}{additional arguments to the \code{grep} function like \code{ignore.case=TRUE} if the pattern should be searched case sensitive or not. 
The default value for \code{ignore.case} is \code{FALSE}.}
}
\value{
If the pattern found then the function returns a data.frame with the 4 columns:
   \tabular{ll}{
     \code{pattern} \tab The pattern which was searched \cr
     \code{concept} \tab The name of the concepts in the data structure \cr
     \code{code} \tab The list of codes where the pattern was found, or the code of a name where the pattern appears \cr
     \code{name} \tab The name/description of the code where the pattern found, or the name of the code where the pattern appears 
   }
   Otherwise returns the value \code{NULL}.
}
\description{
Search the Data Structure Definition (DSD) of a Eurostat dataset for a given pattern. It returns 
             the rows where the pattern appears in the code and name column of the output of the \code{\link{get_eurostat_dsd}} 
             function.
}
\details{
The function returns the line(s) where the searched pattern appears in the code or in the name column.
}
\examples{
\dontshow{
if (parallel::detectCores()<=2){
   options(restatapi_cores=1)
}else{
   options(restatapi_cores=2)
}    
cfg<-get("cfg",envir=restatapi::.restatapi_env) 
rav<-get("rav",envir=restatapi::.restatapi_env)
}
dsd_example<-get_eurostat_dsd("nama_10_gdp",verbose=TRUE)
search_eurostat_dsd("EU",dsd_example)
search_eurostat_dsd("EU",dsd_example,ignore.case=TRUE)
search_eurostat_dsd("EU27_2019",dsd_example,name=FALSE)
search_eurostat_dsd("EU27_2019",dsd_example,exact_match=TRUE)

}
\seealso{
\code{\link{get_eurostat_dsd}}, \code{\link{search_eurostat_toc}}.
}
