% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db-setup-tools.R
\name{db_create}
\alias{db_create}
\title{Create new NCBI database}
\usage{
db_create(db_type = "nucleotide", min_length = 0, max_length = NULL,
  alt_restez_path = NULL)
}
\arguments{
\item{db_type}{character, database type}

\item{min_length}{Minimum sequence length, default 0.}

\item{max_length}{Maximum sequence length, default NULL.}

\item{alt_restez_path}{Alternative restez path if you would like to use the
downloads from a different restez path.}
}
\description{
Create a new local SQL database from downloaded files.
Currently only GenBank/nucleotide/nuccore database is supported.
}
\details{
All .seq.gz files are added to the database. A user can specify sequence
limit sizes for those sequences to be added to the database -- smaller
databases are faster to search.

Alternatively, a user can use the \code{alt_restez_path} to add the files
from an alternative restez file path. For example, you may wish to have a
database of all environmental sequences but then an additional smaller one of
just the sequences with lengths below 100 bp. Instead of having to download
all environmental sequences twice, you can generate multiple restez databases
using the same downloaded files from a single restez path.

This function will not overwrite a pre-existing database. Old databases must
be deleted before a new one can be created. Use \code{\link{db_delete}} with
everything=FALSE to delete an SQL database.

Connections/disconnections to the database are made automatically.
}
\examples{
\dontrun{
library(restez)
restez_path_set(filepath = 'path/for/downloads/and/database')
db_download()
db_create()
}
}
\seealso{
Other database: \code{\link{count_db_ids}},
  \code{\link{db_delete}}, \code{\link{db_download}},
  \code{\link{demo_db_create}}, \code{\link{is_in_db}},
  \code{\link{list_db_ids}}
}
\concept{database}
