/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.circuit;

import gnu.trove.list.array.TIntArrayList;
import java.util.Arrays;
import java.util.BitSet;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public class PropNoSubtour
extends Propagator<IntVar> {
    private final int n;
    private final int offset;
    private final IStateInt[] origin;
    private final IStateInt[] end;
    private final IStateInt[] size;

    public PropNoSubtour(IntVar[] variables, int offset) {
        super((Variable[])variables, (Priority)PropagatorPriority.UNARY, true);
        this.n = ((IntVar[])this.vars).length;
        this.origin = new IStateInt[this.n];
        this.end = new IStateInt[this.n];
        this.size = new IStateInt[this.n];
        IEnvironment environment = this.model.getEnvironment();
        for (int i = 0; i < this.n; ++i) {
            this.origin[i] = environment.makeInt(i);
            this.end[i] = environment.makeInt(i);
            this.size[i] = environment.makeInt(1);
        }
        this.offset = offset;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        TIntArrayList fixedVar = new TIntArrayList();
        for (i = 0; i < this.n; ++i) {
            ((IntVar[])this.vars)[i].removeValue(i + this.offset, this);
            ((IntVar[])this.vars)[i].updateBounds(this.offset, this.n - 1 + this.offset, this);
            if (!((IntVar[])this.vars)[i].isInstantiated()) continue;
            fixedVar.add(i);
        }
        for (i = 0; i < fixedVar.size(); ++i) {
            this.varInstantiated(fixedVar.get(i), ((IntVar[])this.vars)[fixedVar.get(i)].getValue() - this.offset);
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.varInstantiated(idxVarInProp, ((IntVar[])this.vars)[idxVarInProp].getValue() - this.offset);
    }

    private void varInstantiated(int var, int val) throws ContradictionException {
        if (this.isPassive()) {
            return;
        }
        int last = this.end[val].get();
        int start = this.origin[var].get();
        if (this.origin[val].get() != val) {
            this.fails();
        }
        if (this.end[var].get() != var) {
            this.fails();
        }
        if (val == start) {
            if (this.size[start].get() != this.n) {
                this.fails();
            }
        } else {
            this.size[start].add(this.size[val].get());
            if (this.size[start].get() == this.n) {
                ((IntVar[])this.vars)[last].instantiateTo(start + this.offset, this);
                this.setPassive();
            }
            boolean isInst = false;
            if (this.size[start].get() < this.n && ((IntVar[])this.vars)[last].removeValue(start + this.offset, this)) {
                isInst = ((IntVar[])this.vars)[last].isInstantiated();
            }
            this.origin[last].set(start);
            this.end[start].set(last);
            if (isInst) {
                this.varInstantiated(last, ((IntVar[])this.vars)[last].getValue() - this.offset);
            }
        }
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.instantiation();
    }

    @Override
    public ESat isEntailed() {
        for (int i = 0; i < this.n; ++i) {
            if (((IntVar[])this.vars)[i].isInstantiated()) continue;
            return ESat.UNDEFINED;
        }
        BitSet visited = new BitSet(this.n);
        int i = 0;
        for (int size = 0; size != this.n; ++size) {
            if (visited.get(i = ((IntVar[])this.vars)[i].getValue() - this.offset)) {
                return ESat.FALSE;
            }
            visited.set(i);
        }
        if (i == 0) {
            return ESat.TRUE;
        }
        return ESat.FALSE;
    }

    @Override
    public String toString() {
        return "PropNoSubTour(" + Arrays.toString(this.vars) + ")";
    }
}

