/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures.constant;

import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class Set_CstInterval
implements ISet {
    private final int lb;
    private final int ub;
    private final ISetIterator iter = this.newIterator();

    public Set_CstInterval(int min, int max) {
        if (min > max) {
            throw new UnsupportedOperationException("Wrong interval definition [" + min + ", " + max + "] for Set_CstInterval (lb should be lower or equal than ub)");
        }
        assert (min != Integer.MIN_VALUE);
        assert (max != Integer.MAX_VALUE);
        this.lb = min;
        this.ub = max;
    }

    @Override
    public boolean add(int element) {
        if (this.contains(element)) {
            return false;
        }
        throw new UnsupportedOperationException("It is forbidden to add an element to a constant set (Set_CstInterval)");
    }

    @Override
    public boolean remove(int element) {
        if (this.contains(element)) {
            throw new UnsupportedOperationException("It is forbidden to remove an element from a constant set (Set_CstInterval)");
        }
        return false;
    }

    @Override
    public boolean contains(int element) {
        return this.lb <= element && element <= this.ub;
    }

    @Override
    public int size() {
        return this.ub - this.lb + 1;
    }

    @Override
    public void clear() {
        if (!this.isEmpty()) {
            throw new UnsupportedOperationException("It is forbidden to remove an element from a constant set (Set_CstInterval)");
        }
    }

    @Override
    public SetType getSetType() {
        return SetType.FIXED_INTERVAL;
    }

    @Override
    public void registerObserver(ISet set, int idx) {
    }

    @Override
    public int min() {
        return this.lb;
    }

    @Override
    public int max() {
        return this.ub;
    }

    public String toString() {
        return "[" + this.lb + "," + this.ub + "]";
    }

    @Override
    public ISetIterator iterator() {
        this.iter.reset();
        return this.iter;
    }

    @Override
    public ISetIterator newIterator() {
        return new ISetIterator(){
            private int value;
            {
                this.value = Set_CstInterval.this.lb;
            }

            @Override
            public void reset() {
                this.value = Set_CstInterval.this.lb;
            }

            @Override
            public boolean hasNext() {
                return this.value <= Set_CstInterval.this.ub;
            }

            @Override
            public int nextInt() {
                ++this.value;
                return this.value - 1;
            }
        };
    }
}

