/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import gnu.trove.map.hash.TIntIntHashMap;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.tools.ArrayUtils;

public class PropIntersectionFilterSets
extends Propagator<SetVar> {
    private final int k;
    private final ISetDeltaMonitor[] sdm;
    private final IntProcedure onSetAddToKer;
    private final IntProcedure onIntersectionRemoveFromEnv;

    public PropIntersectionFilterSets(SetVar[] sets, SetVar intersection) {
        super((Variable[])ArrayUtils.append(sets, {intersection}), (Priority)PropagatorPriority.QUADRATIC, true);
        if (sets.length == 0) {
            throw new IllegalArgumentException("The intersection of zero sets is undefined.");
        }
        if (sets.length == 1) {
            throw new IllegalArgumentException("This propagator does not work for a single set, use new PropAllEqual(new SetVar[]{sets[0], intersection}) instead.");
        }
        this.k = sets.length;
        this.sdm = new ISetDeltaMonitor[this.k + 1];
        for (int i = 0; i <= this.k; ++i) {
            this.sdm[i] = ((SetVar[])this.vars)[i].monitorDelta(this);
        }
        this.onSetAddToKer = j -> {
            SetVar uniqueSet;
            if (!((SetVar[])this.vars)[this.k].getUB().contains(j) && (uniqueSet = this.findUniqueSetThatDoesNotContainJInLB(j)) != null) {
                uniqueSet.remove(j, this);
            }
        };
        this.onIntersectionRemoveFromEnv = j -> {
            SetVar uniqueSet = this.findUniqueSetThatDoesNotContainJInLB(j);
            if (uniqueSet != null) {
                uniqueSet.remove(j, this);
            }
        };
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx < this.k) {
            return SetEventType.ADD_TO_KER.getMask();
        }
        return SetEventType.REMOVE_FROM_ENVELOPE.getMask();
    }

    private SetVar findSetThatDoesNotContainJInLB(int j) {
        for (int i = 0; i < this.k - 1; ++i) {
            if (((SetVar[])this.vars)[i].getLB().contains(j)) continue;
            return ((SetVar[])this.vars)[i];
        }
        return ((SetVar[])this.vars)[this.k - 1];
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        SetVar intersection = ((SetVar[])this.vars)[this.k];
        TIntIntHashMap count = new TIntIntHashMap();
        for (i = 0; i < this.k; ++i) {
            ISetIterator iter = ((SetVar[])this.vars)[i].getLB().iterator();
            while (iter.hasNext()) {
                int j = iter.nextInt();
                if (intersection.getUB().contains(j) || count.adjustOrPutValue(j, 1, 1) < this.k - 1) continue;
                this.findSetThatDoesNotContainJInLB(j).remove(j, this);
            }
        }
        for (i = 0; i <= this.k; ++i) {
            this.sdm[i].startMonitoring();
        }
    }

    private SetVar findUniqueSetThatDoesNotContainJInLB(int j) {
        SetVar uniqueSet = null;
        for (int i = 0; i < this.k; ++i) {
            if (((SetVar[])this.vars)[i].getLB().contains(j)) continue;
            if (uniqueSet != null) {
                return null;
            }
            uniqueSet = ((SetVar[])this.vars)[i];
        }
        return uniqueSet;
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (idxVarInProp < this.k) {
            this.sdm[idxVarInProp].forEach(this.onSetAddToKer, SetEventType.ADD_TO_KER);
        } else {
            this.sdm[idxVarInProp].forEach(this.onIntersectionRemoveFromEnv, SetEventType.REMOVE_FROM_ENVELOPE);
        }
    }

    @Override
    public ESat isEntailed() {
        return ESat.TRUE;
    }
}

