% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/restorepoint.R
\name{restore.point.browser}
\alias{restore.point.browser}
\title{Examing a previously stored restore point by invoking the browser.}
\usage{
restore.point.browser(name, was.forced = FALSE,
  message.text = paste("restore point", name, ", press ESC to return."),
  deep.copy = get.restore.point.options()$deep.copy)
}
\arguments{
\item{name}{name under which the variables have been stored}

\item{was.forced}{flag whether storage of objects was forced. If FALSE (default) a warning is shown if restore.objects is called and is.storing()==FALSE, since probably no objects have been stored.}

\item{message.text}{initial shown message}

\item{deep.copy}{when storing or restoring tries to make a deep copy of R objects that are by default copied by reference, like environments. Setting deep.copy = FALSE can substantially speed up restore.point, however.}
}
\value{
returns nothing
}
\description{
The function is mainly for internal use by restore.point.
}

\examples{\dontrun{
  library(restorepoint)
  
  set.restore.point.options(to.global = FALSE)
  
  # A function that shall swap the left and right part of a vector
  swap.in.vector = function(vec,swap.ind) {
    restore.point("swap.in.vector")
    left  = vec[1:(swap.ind-1)]
    right = vec[swap.ind:nrow(vec)]
    c(right,left)
  }
  swap.in.vector(1:10,4)
  
  # You could call
  restore.point.browser("swap.in.vector")
  
  # But there is no need to. Just running in the R Console (global environment) the command
  restore.point("swap.in.vector")
  # has the same effect (at least once you have set restore.point.options(to.global=FALSE))
  
  # Basically restore.point.browser() is rather an internal function
}}
