% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcd.R
\name{gcd}
\alias{gcd}
\title{Greatest common divisor of two polynomials}
\usage{
gcd(qspray1, qspray2, utcf = FALSE)
}
\arguments{
\item{qspray1, qspray2}{two \code{qspray} polynomials with at more nine
variables}

\item{utcf}{Boolean, whether to get the greatest common divisor up to a
constant factor (this can be faster)}
}
\value{
A \code{qspray} polynomial.
}
\description{
Greatest common divisor of two polynomials with rational
  coefficients.
}
\examples{
library(resultant)
x <- qlone(1)
y <- qlone(2)
g <- x^2 + 2*x*y + 1
p <- g * (y^2 + x^2)
q <- g * (y + x^3 + 2)
gcd(p, q)
}
