% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document_waves.R
\name{document_waves}
\alias{document_waves}
\title{Document survey lists}
\usage{
document_waves(survey_list)
}
\arguments{
\item{survey_list}{A list of \code{\link{survey}} objects.}
}
\value{
Returns a data frame with the key attributes of the surveys 
in a survey list: the name of the data file, the number of rows and 
columns, and the size of the object as stored in memory.
}
\description{
Document survey lists
}
\examples{
examples_dir <- system.file( "examples", package = "retroharmonize")
                        
my_rds_files <- dir( examples_dir)[grepl(".rds", 
                                   dir(examples_dir))]

example_surveys <- read_surveys(file.path(examples_dir, my_rds_files))
 
waves_document <- document_waves(example_surveys)

attr(waves_document, "original_list" )
waves_document
}
\seealso{
Other documentation functions: 
\code{\link{document_survey_item}()}
}
\concept{documentation functions}
