% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na_range_to_values.R
\name{na_range_to_values}
\alias{na_range_to_values}
\alias{is.na_range_to_values}
\title{Harmonize user-defined missing value ranges}
\usage{
na_range_to_values(x)

is.na_range_to_values(x)
}
\arguments{
\item{x}{A labelled_spss or labelled_spss_survey vector}
}
\value{
A \code{x} with harmonized \code{na_values} and 
\code{na_range} attributes.
If \code{min(na_values)} or \code{max(na_values)} than the left- and 
right-hand value of \code{na_range}, it gives a warning and adjusts
the original \code{na_range}.
}
\description{
Harmonize the \code{na_values} attribute with 
\code{na_range}, if the latter is present.
}
\details{
\code{na_range_to_values()} tests if the function needs to be 
called for \code{na_values} harmonization. The \code{na_range}
is often missing and less likely to cause logical problems 
when joining survey answers.
}
\examples{
var1 <- labelled::labelled_spss(
  x = c(1,0,1,1,0,8,9), 
  labels = c("TRUST" = 1, 
             "NOT TRUST" = 0, 
             "DON'T KNOW" = 8, 
             "INAP. HERE" = 9), 
na_range = c(8,12))
  
na_range_to_values(var1)
as_numeric(na_range_to_values(var1))
as_character(na_range_to_values(var1))
}
\seealso{
Other variable label harmonization functions: 
\code{\link{harmonize_values}()},
\code{\link{harmonize_waves}()},
\code{\link{label_normalize}()}
}
\concept{variable label harmonization functions}
