% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classConfInt.R
\name{classConfInt}
\alias{classConfInt}
\title{Classification Confidence Intervals}
\usage{
classConfInt(rf, conf.level = 0.95, threshold = NULL)
}
\arguments{
\item{rf}{a \code{\link[randomForest]{randomForest}} object}

\item{conf.level}{confidence level for the \code{\link{binom.test}} confidence interval}

\item{threshold}{threshold to test observed classification probability against.}
}
\value{
A matrix with the following columns for each class and overall:
\describe{
  \item{pct.correct}{percent correctly classified}
  \item{LCI_##, UCI_##}{the lower and upper central confidence intervals given \code{conf.level}}
  \item{Pr.gt_##}{the probability that the true classification probability is >= \code{threshold}}
}
}
\description{
Calculate confidence intervals for Random Forest classifications
}
\examples{
data(symb.metab)

rf <- randomForest(type ~ ., symb.metab)
classConfInt(rf)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
