% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pctCorrect.R
\name{pctCorrect}
\alias{pctCorrect}
\title{Percent Correctly Classified}
\usage{
pctCorrect(x, pct = c(seq(0.8, 0.95, 0.05), 0.99))
}
\arguments{
\item{x}{a \code{rfPermte} or \code{randomForest} model object.}

\item{pct}{vector of minimum percent of trees voting for each class. Can be 
\code{0:1} or \code{0:100}.}
}
\value{
a matrix giving the percent of individuals correctly classified in 
  each class and overall for each threshold value specified in \code{pct}.
}
\description{
For classification models, calculate the percent of 
  individuals correctly classified in a specified percent of trees in 
  the forest.
}
\examples{
library(randomForest)
data(mtcars)

rf <- randomForest(factor(am) ~ ., mtcars, importance = TRUE)
pctCorrect(rf)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
