% Generated by roxygen2 (4.0.2): do not edit by hand
\name{MultiColinear}
\alias{MultiColinear}
\title{Multicolinear test}
\usage{
MultiColinear(x, p = 1e-07)
}
\arguments{
\item{x}{data.frame or matrix object}

\item{p}{multicolinearity threshold}
}
\value{
test statistic message

names character vector of multicolineary variables
}
\description{
Test for multicolinearity in data using qr-matrix decomposition
}
\note{
Colinearity threhold needs to be adjusted based on number of parameters. For small number(s) of varialbes (<20) use ~1e-07 and for larger ~0.05
}
\examples{
test <- data.frame(v1=seq(0.1, 5, length=100), v2=seq(0.1, 5, length=100),
                   v3=dnorm(runif(100)), v4=dnorm(runif(100)))
  ( cl <- MultiColinear(test) )

# PCA biplot of variables
pca.test <- prcomp(test[,1:ncol(test)], scale=TRUE)
  biplot(pca.test, arrow.len=0.1, xlabs=rep(".", length(pca.test$x[,1])))

 # Remove identified variable(s)
 test <- test[,-which(names(test)==cl)]
}
\author{
Jeffrey S. Evans  <jeffrey_evans<at>tnc.org>
}
\references{
Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988) The New S Language. Wadsworth & Brooks/Cole.

Dongarra, J. J., Bunch, J. R., Moler, C. B. and Stewart, G. W. (1978) LINPACK Users Guide. Philadelphia: SIAM Publications.
}

