% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counts.R
\name{counts}
\alias{counts}
\title{Generate counts}
\usage{
counts(
  FARS,
  what = "crashes",
  years = NULL,
  interval = "year",
  where = NULL,
  who = NULL,
  involved = NULL,
  filterOnly = FALSE
)
}
\arguments{
\item{FARS}{The input FARS object.}

\item{what}{What to count: crashes, fatalities, or people involved.}

\item{years}{The years over which to count.}

\item{interval}{The interval in which to count: months or years.}

\item{where}{Where to count: can specify rural/urban and/or state (e.g.,
where = "rural Virginia", where = "rural", where = "North Carolina")}

\item{who}{The type of person to count: driver, passenger, pedestrian,
bicyclist, or motorcyclist.}

\item{involved}{Factors involved with the crash. Can be any of: distracted
driver, drowsy driver, police pursuit, motorcycle, pedalcyclist,
bicyclist, pedestrian, pedbike, young driver, older driver, speeding,
alcohol, drugs, hit and run, roadway departure, rollover, or large
trucks.}

\item{filterOnly}{Logical, whether to only filter data or reduce to counts.}
}
\value{
Either a filtered tibble (filterOnly=TRUE) or a tibble of counts
    (filterOnly=FALSE). If filterOnly=TRUE, the tibble that is returned is
    the 'flat' tibble from the input FARS object, filtered according to other
    parameters.
}
\description{
Use FARS data to generate commonly requested counts.
}
\examples{
\donttest{
get_fars(years = 2020, states="Virginia") \%>\%
   counts(
     where = "rural"
     )

get_fars(years = 2020, states="FL") \%>\%
   counts(
     involved = "older driver"
     )

get_fars(years = 2020, states = "21") \%>\%
   counts(
     involved = c("young driver", "alcohol")
     )
}
}
