/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.delta.monitor;

import org.chocosolver.solver.Cause;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.search.loop.TimeStampedObject;
import org.chocosolver.solver.variables.delta.IEnumDelta;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.procedure.SafeIntProcedure;

public class EnumDeltaMonitor
extends TimeStampedObject
implements IIntDeltaMonitor {
    private final IEnumDelta delta;
    private int first;
    private int last;
    private final ICause propagator;

    public EnumDeltaMonitor(IEnumDelta delta, ICause propagator) {
        super(delta.getEnvironment());
        this.delta = delta;
        this.first = 0;
        this.last = 0;
        this.propagator = propagator;
    }

    @Override
    public void startMonitoring() {
        this.delta.lazyClear();
        this.resetStamp();
        this.first = this.last = this.delta.size();
    }

    private void freeze() {
        if (this.getTimeStamp() == -1) {
            throw new SolverException("Delta Monitor created in this is not activated. This should be the last instruction of p.propagate(int) by calling `monitor.startMonitoring()`");
        }
        if (this.needReset()) {
            this.delta.lazyClear();
            this.first = 0;
            this.last = 0;
            this.resetStamp();
        }
        if (this.getTimeStamp() != ((TimeStampedObject)((Object)this.delta)).getTimeStamp()) {
            throw new SolverException("Delta and monitor are not synchronized. \ndeltamonitor.freeze() is called but no value has been removed since the last call.");
        }
        this.first = this.last;
        this.last = this.delta.size();
    }

    @Override
    public void forEachRemVal(SafeIntProcedure proc) {
        this.freeze();
        while (this.first < this.last) {
            if (this.propagator == Cause.Null || this.propagator != this.delta.getCause(this.first)) {
                proc.execute(this.delta.get(this.first));
            }
            ++this.first;
        }
    }

    @Override
    public void forEachRemVal(IntProcedure proc) throws ContradictionException {
        this.freeze();
        while (this.first < this.last) {
            if (this.propagator == Cause.Null || this.propagator != this.delta.getCause(this.first)) {
                proc.execute(this.delta.get(this.first));
            }
            ++this.first;
        }
    }

    public String toString() {
        return String.format("(%d,%d) :: %d", this.first, this.last, this.delta.size());
    }

    @Override
    public int sizeApproximation() {
        return this.last - this.first;
    }
}

