% Generated by roxygen2 (4.0.2): do not edit by hand
\name{occ_metadata}
\alias{occ_metadata}
\title{Search for catalog numbers, collection codes, collector names, and institution
codes.}
\usage{
occ_metadata(type = "catalogNumber", q = NULL, limit = 5, pretty = TRUE,
  ...)
}
\arguments{
\item{type}{Type of data, one of catalog_number, collection_code, collector_name,
institution_code. Unique partial strings work too, like 'cat' for catalog_number}

\item{q}{Search term}

\item{limit}{Number of results, default=5}

\item{pretty}{Pretty as true (Default) uses cat to print data, FALSE gives
character strings.}

\item{...}{Further named parameters, such as \code{query}, \code{path}, etc, passed on to
\code{\link[httr]{modify_url}} within \code{\link[httr]{GET}} call. Unnamed parameters will be
combined with \code{\link[httr]{config}}.}
}
\description{
Search for catalog numbers, collection codes, collector names, and institution
codes.
}
\examples{
\dontrun{
# catalog number
occ_metadata(type = "catalogNumber", q=122)

# collection code
occ_metadata(type = "collectionCode", q=12)

# institution code
occ_metadata(type = "institutionCode", q='GB')

# data as character strings
occ_metadata(type = "catalogNumber", q=122, pretty=FALSE)

# Change number of results returned
occ_metadata(type = "catalogNumber", q=122, limit=10)

# Partial unique type strings work too
occ_metadata(type = "cat", q=122)

# Pass on options to httr
library('httr')
occ_metadata(type = "cat", q=122, config=verbose())
occ_metadata(type = "cat", q=122, config=progress())
}
}
\references{
\url{http://www.gbif.org/developer/occurrence#search}
}

