% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_metrics.r
\name{dataset_metrics}
\alias{dataset_metrics}
\title{Get details on a GBIF dataset.}
\usage{
dataset_metrics(uuid, curlopts = list())
}
\arguments{
\item{uuid}{(character) One or more dataset UUIDs. See examples.}

\item{curlopts}{list of named curl options passed on to
\code{\link[crul]{HttpClient}}. see \code{curl::curl_options}
for curl options}
}
\description{
Get details on a GBIF dataset.
}
\note{
Dataset metrics are only available for checklist type datasets.
}
\examples{
\dontrun{
dataset_metrics(uuid='863e6d6b-f602-4495-ac30-881482b6f799')
dataset_metrics(uuid='66dd0960-2d7d-46ee-a491-87b9adcfe7b1')
dataset_metrics(uuid=c('863e6d6b-f602-4495-ac30-881482b6f799',
   '66dd0960-2d7d-46ee-a491-87b9adcfe7b1'))
dataset_metrics(uuid='66dd0960-2d7d-46ee-a491-87b9adcfe7b1',
  curlopts = list(verbose=TRUE))
}
}
\references{
\url{http://www.gbif.org/developer/registry#datasetMetrics}
}
