% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/name_suggest.r
\name{name_suggest}
\alias{name_suggest}
\title{Suggest up to 20 name usages.}
\usage{
name_suggest(
  q = NULL,
  datasetKey = NULL,
  rank = NULL,
  fields = NULL,
  start = NULL,
  limit = 100,
  curlopts = list()
)
}
\arguments{
\item{q}{(character, required) Simple search parameter. The value for
this parameter can be a simple word or a phrase. Wildcards can be added to
the simple word parameters only, e.g. q=\emph{puma}}

\item{datasetKey}{(character) Filters by the checklist dataset key (a uuid,
see examples)}

\item{rank}{(character) A taxonomic rank. One of class, cultivar,
cultivar_group, domain, family, form, genus, informal, infrageneric_name,
infraorder, infraspecific_name, infrasubspecific_name, kingdom, order,
phylum, section, series, species, strain, subclass, subfamily, subform,
subgenus, subkingdom, suborder, subphylum, subsection, subseries,
subspecies, subtribe, subvariety, superclass, superfamily, superorder,
superphylum, suprageneric_name, tribe, unranked, or variety.}

\item{fields}{(character) Fields to return in output data.frame (simply
prunes columns off)}

\item{start}{Record number to start at. Default: 0. Use in combination
with \code{limit} to page through results.}

\item{limit}{Number of records to return. Default: 100. Maximum: 1000.}

\item{curlopts}{list of named curl options passed on to
\code{\link[crul]{HttpClient}}. see \code{curl::curl_options}
for curl options}
}
\value{
A list, with two elements \code{data} (tibble) and \code{hierarchy} (list of
data.frame's). If 'higherClassificationMap' is one of the \code{fields} requested,
then \code{hierarchy} is a list of data.frame's; if not included, \code{hierarchy}
is an empty list.
}
\description{
A quick and simple autocomplete service that returns up to 20 name
usages by doing prefix matching against the scientific name. Results
are ordered by relevance.
}
\section{Repeat parmeter inputs}{

Some parameters can take many inputs, and treated as 'OR' (e.g., a or b or
c). The following take many inputs:
\itemize{
\item \strong{rank}
\item \strong{datasetKey}
}

see also \link{many-values}
}

\examples{
\dontrun{
name_suggest(q='Puma concolor')
name_suggest(q='Puma')
name_suggest(q='Puma', rank="genus")
name_suggest(q='Puma', rank="subspecies")
name_suggest(q='Puma', rank="species")
name_suggest(q='Puma', rank="infraspecific_name")

name_suggest(q='Puma', limit=2)
name_suggest(q='Puma', fields=c('key','canonicalName'))
name_suggest(q='Puma', fields=c('key','canonicalName',
  'higherClassificationMap'))

# Some parameters accept many inputs, treated as OR
name_suggest(rank = c("family", "genus"))
name_suggest(datasetKey = c("73605f3a-af85-4ade-bbc5-522bfb90d847",
  "d7c60346-44b6-400d-ba27-8d3fbeffc8a5"))

# If 'higherClassificationMap' in fields, a list is returned
name_suggest(q='Puma', fields=c('key','higherClassificationMap'))

# Pass on curl options
name_suggest(q='Puma', limit=200, curlopts = list(verbose=TRUE))
}
}
\references{
\url{http://www.gbif.org/developer/species#searching}
}
