% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgeos_misc.R
\name{gNearestPoints}
\alias{gNearestPoints}
\title{Closest Points of two Geometries}
\usage{
gNearestPoints(spgeom1, spgeom2)
}
\arguments{
\item{spgeom1, spgeom2}{sp objects as defined in package sp.}
}
\value{
The closest points of the two geometries or NULL on exception.
  The first point comes from spgeom1 geometry and the second point comes
  from spgeom2.
}
\description{
Return closest points of two geometries.
}
\examples{
g1 <- readWKT("MULTILINESTRING((34 54, 60 34), (0 10, 50 10, 100 50))")
g2 <- readWKT("MULTIPOINT(30 0, 100 30)")
plot(g1, pch=4, axes=TRUE)
plot(g2, add=TRUE)
plot(gNearestPoints(g1, g2), add=TRUE, col="red", pch=7)
gDistance(g1, g2)
}
\seealso{
gDistance
}
\author{
Rainer Stuetz
}
\keyword{spatial}
