% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sklearn-cluster.R
\name{MeanShift}
\alias{MeanShift}
\title{Performs clustering according to the mean shift algorithm}
\description{
This is a wrapper around the Python class
\href{https://scikit-learn.org/stable/modules/generated/sklearn.cluster.MeanShift.html#sklearn.cluster.MeanShift}{sklearn.cluster.MeanShift}.
}
\examples{
\dontshow{if (reticulate::py_module_available("sklearn.cluster")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
cl <- MeanShift$new()
\dontshow{\}) # examplesIf}
}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{rgudhi::SKLearnClass} -> \code{\link[rgudhi:BaseClustering]{rgudhi::BaseClustering}} -> \code{MeanShift}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MeanShift-new}{\code{MeanShift$new()}}
\item \href{#method-MeanShift-clone}{\code{MeanShift$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="apply"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-apply'><code>rgudhi::SKLearnClass$apply()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="fit"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-fit'><code>rgudhi::SKLearnClass$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="fit_transform"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-fit_transform'><code>rgudhi::SKLearnClass$fit_transform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="get_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-get_params'><code>rgudhi::SKLearnClass$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="set_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-set_params'><code>rgudhi::SKLearnClass$set_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="transform"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-transform'><code>rgudhi::SKLearnClass$transform()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeanShift-new"></a>}}
\if{latex}{\out{\hypertarget{method-MeanShift-new}{}}}
\subsection{Method \code{new()}}{
The \link{MeanShift} class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeanShift$new(
  bandwidth = NULL,
  seeds = NULL,
  bin_seeding = FALSE,
  min_bin_freq = 1L,
  cluster_all = TRUE,
  n_jobs = 1L,
  max_iter = 300L
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{bandwidth}}{A numeric value specifying the bandwidth used in the RBF
kernel. If \code{NULL}, the bandwidth is estimated using
\href{https://scikit-learn.org/stable/modules/generated/sklearn.cluster.estimate_bandwidth.html}{sklearn.cluster.estimate_bandwidth()}.
Defaults to \code{NULL}.}

\item{\code{seeds}}{A numeric matrix of shape \eqn{n_\mathrm{samples} \times
  n_\mathrm{features}} specifying the seeds used to initialize kernels.
If \code{NULL}, the seeds are calculated by
\code{sklearn.cluster.get_bin_seeds()} with bandwidth as the grid size and
default values for other parameters. Defaults to \code{NULL}.}

\item{\code{bin_seeding}}{A boolean value specifying whether initial kernel
locations are not locations of all points, but rather the location of
the discretized version of points, where points are binned onto a grid
whose coarseness corresponds to the bandwidth. Setting this option to
\code{TRUE} will speed up the algorithm because fewer seeds will be
initialized. Defaults to \code{FALSE}. Ignored if \code{seeds} is not \code{NULL}.}

\item{\code{min_bin_freq}}{An integer value specifying the minimal size of bins.
To speed up the algorithm, accept only those bins with at least
\code{min_bin_freq} points as seeds. Defaults to \code{1L}.}

\item{\code{cluster_all}}{A boolean value specifying whether all points are
clustered, even those orphans that are not within any kernel. Orphans
are assigned to the nearest kernel. If \code{FALSE}, then orphans are given
cluster label \code{-1}. Defaults to \code{TRUE}.}

\item{\code{n_jobs}}{An integer value specifying the number of jobs to use for
the computation. This works by computing each of the \code{n_init} runs in
parallel. Defaults to \code{1L}.}

\item{\code{max_iter}}{An integer value specifying the maximum number of
iterations per seed point before the clustering operation terminates
(for that seed point) if it has not yet converged. Defaults to \code{300L}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \link{MeanShift}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeanShift-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MeanShift-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeanShift$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
